<?php
/**
 * Test script to check orders.php issues
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Testing Orders Page</h1>";

// Test 1: Check config file
echo "<h2>1. Testing config.php</h2>";
try {
    require_once '../includes/config.php';
    echo "✓ Config loaded successfully<br>";
    echo "Database: " . DB_NAME . "<br>";
    echo "PDO object: " . (isset($pdo) ? "✓ Set" : "✗ Not set") . "<br>";
} catch (Exception $e) {
    die("✗ Config error: " . $e->getMessage());
}

// Test 2: Check functions file
echo "<h2>2. Testing functions.php</h2>";
try {
    require_once '../includes/functions.php';
    echo "✓ Functions loaded successfully<br>";
    echo "format_currency exists: " . (function_exists('format_currency') ? "✓" : "✗") . "<br>";
    echo "sanitize exists: " . (function_exists('sanitize') ? "✓" : "✗") . "<br>";
} catch (Exception $e) {
    die("✗ Functions error: " . $e->getMessage());
}

// Test 3: Check database connection
echo "<h2>3. Testing database connection</h2>";
try {
    $test = $pdo->query("SELECT 1");
    echo "✓ Database connection works<br>";
} catch (PDOException $e) {
    die("✗ Database error: " . $e->getMessage());
}

// Test 4: Check if table exists
echo "<h2>4. Testing table existence</h2>";
try {
    $stmt = $pdo->query("SHOW TABLES LIKE 'binance_p2p_orders'");
    $tableExists = $stmt->rowCount() > 0;
    if ($tableExists) {
        echo "✓ Table 'binance_p2p_orders' exists<br>";
        
        // Test query
        $count = $pdo->query("SELECT COUNT(*) as total FROM binance_p2p_orders")->fetch(PDO::FETCH_ASSOC);
        echo "Total orders: " . $count['total'] . "<br>";
    } else {
        echo "✗ Table 'binance_p2p_orders' does NOT exist<br>";
        echo "Run: mysql -u " . DB_USER . " -p " . DB_NAME . " < ../database/binance_p2p_orders.sql<br>";
    }
} catch (PDOException $e) {
    die("✗ Table check error: " . $e->getMessage());
}

// Test 5: Check session
echo "<h2>5. Testing session</h2>";
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
echo "Session status: " . (session_status() === PHP_SESSION_ACTIVE ? "✓ Active" : "✗ Not active") . "<br>";

echo "<h2>All tests completed!</h2>";
echo "<a href='orders.php'>Try orders.php again</a>";
?>

